import SSSG, { Plugin } from "sssg";
import Dev from "sssg/src/plugins/dev";
import TSCompiler from "sssg/src/plugins/ts-compiler";
import * as path from "path";

const sssg = new SSSG({
  outputFolder: path.join(__dirname, "dist"),
  inputFolder: path.join(__dirname, "src"),
});

const plugins: Plugin[] = [];

if (process.argv.includes("--dev")) {
  plugins.push(new Dev(sssg, {}));
} 
await sssg.run({
  plugins: plugins.concat([
    new TSCompiler(!process.argv.includes("--dev")),
  ]),
});

await sssg.build();